#!/bin/bash
#SBATCH --ntasks-per-node=40
#SBATCH --nodes=1
#SBATCH --time=2:30:00

cd $SLURM_SUBMIT_DIR


REF=../HUMAN_REFS/HG38/hs38.fa

module load GATK/3.8.1

#variable file contains $sampleID and location of fastq files 
. variables



#########################
# GATK variants calling
#########################

java -Xmx150g -jar /local/software/GATK/GenomeAnalysisTK-3.8-1-0-gf15c1c3ef/GenomeAnalysisTK.jar \
	-T HaplotypeCaller \
	-nct 40 \
	-ERC GVCF \
	-R $REF \
	-I ${sampleID}.GATK.recal.bam \
	-o ${sampleID}.g.vcf.gz \
	--dontUseSoftClippedBases 


